/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.api.scheduler;

import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.impactdev.impactor.api.Impactor;
import net.impactdev.impactor.api.logging.PluginLogger;
import net.impactdev.impactor.api.scheduler.SchedulerAdapter;
import net.impactdev.impactor.api.scheduler.SchedulerTask;

public abstract class AbstractJavaScheduler
implements SchedulerAdapter {
    private static final String THREAD_NAME = "Impactor Scheduler";
    private static final String WORKER_PREFIX = "Impactor Worker - ";
    private static final int PARALLELISM = 16;
    private final PluginLogger logger;
    private final ScheduledThreadPoolExecutor scheduler;
    private final ForkJoinPool worker;

    public AbstractJavaScheduler(PluginLogger logger) {
        this.logger = logger;
        this.scheduler = new ScheduledThreadPoolExecutor(1, r -> {
            Thread thread2 = Executors.defaultThreadFactory().newThread(r);
            thread2.setName(THREAD_NAME);
            thread2.setDaemon(true);
            return thread2;
        });
        this.scheduler.setRemoveOnCancelPolicy(true);
        this.scheduler.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.worker = new ForkJoinPool(16, new WorkerThreadFactory(), new ExceptionHandler(), false);
    }

    @Override
    public Executor async() {
        return this.worker;
    }

    @Override
    public SchedulerTask asyncLater(Runnable task, long delay, TimeUnit unit) {
        ScheduledFuture<?> future = this.scheduler.schedule(() -> this.worker.execute(task), delay, unit);
        return () -> future.cancel(false);
    }

    @Override
    public SchedulerTask asyncRepeating(Runnable task, long interval, TimeUnit unit) {
        ScheduledFuture<?> future = this.scheduler.scheduleAtFixedRate(() -> this.worker.execute(task), interval, interval, unit);
        return () -> future.cancel(false);
    }

    @Override
    public SchedulerTask asyncDelayedAndRepeating(Runnable task, long delay, long interval, TimeUnit unit) {
        ScheduledFuture<?> future = this.scheduler.scheduleAtFixedRate(() -> this.worker.execute(task), interval, interval, unit);
        return () -> future.cancel(false);
    }

    public void shutdownScheduler() {
        this.scheduler.shutdown();
        try {
            if (!this.scheduler.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.logger.severe("Timed out waiting for the Impactor scheduler to terminate");
                this.reportRunningTasks(thread2 -> thread2.getName().equals(THREAD_NAME));
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void shutdownExecutor() {
        this.worker.shutdown();
        try {
            if (!this.worker.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.logger.severe("Timed out waiting for the Impactor worker thread pool to terminate");
                this.reportRunningTasks(thread2 -> thread2.getName().startsWith(WORKER_PREFIX));
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void reportRunningTasks(Predicate<Thread> predicate) {
        Thread.getAllStackTraces().forEach((thread2, stack) -> {
            if (predicate.test((Thread)thread2)) {
                this.logger.warn("Thread " + thread2.getName() + " is blocked, and may be the reason for the slow shutdown!\n" + Arrays.stream(stack).map(el -> "  " + String.valueOf(el)).collect(Collectors.joining("\n")));
            }
        });
    }

    private static final class WorkerThreadFactory
    implements ForkJoinPool.ForkJoinWorkerThreadFactory {
        private static final AtomicInteger COUNT = new AtomicInteger(0);

        private WorkerThreadFactory() {
        }

        @Override
        public ForkJoinWorkerThread newThread(ForkJoinPool pool) {
            ForkJoinWorkerThread thread2 = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
            thread2.setDaemon(true);
            thread2.setName(AbstractJavaScheduler.WORKER_PREFIX + COUNT.getAndIncrement());
            thread2.setContextClassLoader(Impactor.class.getClassLoader());
            return thread2;
        }
    }

    private final class ExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private ExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            AbstractJavaScheduler.this.logger.warn("Thread " + t.getName() + " threw an uncaught exception", e);
        }
    }
}

